'use strict';

angular.module('genisis').controller('genisisCtrl', ['$rootScope', 'user',
  'session', '$route', '$routeParams', '$location', 'ENV', 'system',

  function ($rootScope, $user, $session, $route, $routeParams, $location,
    ENV, $system) {

    //load any existing session data
    $rootScope.session = $session.get();

    //put global services onto root scope
    $rootScope.dmHelpURL = ENV.dmHelpURL;
    $rootScope.dsmHelpURL = ENV.dsmHelpURL;
    $rootScope.requesterHelpURL = ENV.requesterHelpURL;
    $rootScope.route = $route;
    $rootScope.routeParams = $routeParams;
    $rootScope.location = $location;
    $rootScope.system = $system;
    $rootScope.user = $user;
    $rootScope.isLogoutPath = false;

    //toggle debugging output
    $rootScope.debugMode = false;

    //create an array to hold page errors
    $rootScope.errors = [];

    //create an array to hold warnings
    $rootScope.warnings = [];

    //create an array to hold messages
    $rootScope.messages = [];

    //get todays date
    $rootScope.date = new Date();

    $rootScope.config = {
      pageTitle: 'Genomic Information System for Integrated Science',
      logo: 'images/logo.jpg',
      copyright: 'U.S. Department of Veterans Affairs',
      address: '810 Vermont Avenue, NW Washington DC 20420'
    };
  }
]);